---
title: Developers
---

Developer features allow extending and enhancing Chart.js in many different ways.

## Latest resources

Latest documentation and samples, including unreleased features, are available at:

- https://www.chartjs.org/docs/master/
- https://www.chartjs.org/samples/master/

## Development releases

Latest builds are available for testing at:

- https://www.chartjs.org/dist/master/chart.js
- https://www.chartjs.org/dist/master/chart.min.js

**WARNING: Development builds MUST not be used for production purposes or as replacement for CDN.**

## Browser support

Chart.js offers support for the following browsers:

- Chrome 50+
- Firefox 45+
- Internet Explorer 11
- Edge 14+
- Safari 9+

Browser support for the canvas element is available in all modern & major mobile browsers. [CanIUse](https://caniuse.com/#feat=canvas)

Thanks to [BrowserStack](https://browserstack.com) for allowing our team to test on thousands of browsers.

## Previous versions

To migrate from version 3 to version 2, please see [the v3 migration guide](../getting-started/v3-migration).

Version 2 has a completely different API than earlier versions.

Most earlier version options have current equivalents or are the same.

Please note - documentation for previous versions are available online or in the GitHub repo.

- [2.9.3 Documentation](https://www.chartjs.org/docs/2.9.3/)
- [1.x Documentation](https://github.com/chartjs/Chart.js/tree/v1.1.1/docs)
