<?php
include("../../configs/autoload.php");
require '../../vendor/autoload.php';
//require_once 'vendor/dompdf/autoload.inc.php';
use Dompdf\Dompdf;
use Dompdf\Options;
if(!$_GET['action'])
{
	$_GET['action']='view-invoice';
}
 
if($_GET['user_id'])
{
	$_GET['user_id']=decrypt($_GET['user_id']);
}
if($_GET['id'])
{
	$_GET['id']=decrypt($_GET['id']);
		
}
if($_GET['del_id'])
{
	$_GET['del_id']=decrypt($_GET['del_id']);
}

$data['breadcrumb']=[];
$data['page_title']="Invoice";

if($_POST['action'])
{
	$_GET['action']=$_POST['action'];
}
 
switch($_GET['action'])
{
	case "view-invoice":
	case "search-invoice":
		$data['page_subtitle']="View Invoice";

		$data['breadcrumb']=array("Invoice"=>"");
		$data['btn']="<a href='" . $configs['vpath']."invoice/create-all-invoice' class='btn btn-danger pull-right'><i class='fa fa-plus'></i> Create All invoice</a> <a href='" . $configs['vpath']."invoice/add-invoice' class='btn btn-success pull-right'><i class='fa fa-plus'></i> Add New invoice</a>";
		$query=[];
		if($_GET['user_id'])
		{
			$query=array_merge($query,array("user_id"=>$_GET['user_id']));
					
		}
		if($_POST['id'])
		{
			$query=array_merge($query,array("id"=>$_POST['id']));
					
		}
		$data['total'] = getTotalRow('invoice',$query);
		
		$data['page_subtitle'] = "View Invoice (" .$data['total'] .")";
		
	    $data['db_list'] = getQuery('invoice','*',$query,"due_date",$configs['limit']);
	    
	     
	    if($_GET['del_id'])
		{

			$r=deleteData("invoice",array("id"=>$_GET['del_id']));
		
			$data['msg']=$configs['delete_msg'];
		}
	
	break;

	
	case "edit-invoice":
	
		$data['page_subtitle']="Edit Invoice";

		$data['breadcrumb']=array("All Invoice"=>$configs['vpath'] ."invoice/view-invoice","Edit Invoice :" . $_GET['id']=>"");
	 
		$data['db_value']= getDataByWhere('invoice','*',array('id'=>$_GET['id']));
		
		$data['db_value']['student_name']=getFldValueById("student","concat(first_name,' ',last_name)",array("user_id"=>$data['db_value']['user_id'])); 
	
	break;

	case "add-invoice":
	
		$data['page_subtitle']="Add Invoice";

		$data['breadcrumb']=array("All Invoice"=>$configs['vpath'] ."invoice/view-invoice","Add Invoice"=>"");
		
		$data['student_list']=getQueryByJoin(array("student as s","login as l"),"s.*",array("l.status"=>"Y"),array("s.user_id"=>"l.user_id"),"s.first_name");
	
	break;
	
	case "create-all-invoice":
	
		$data['page_subtitle']="Create All Invoice";

		$data['breadcrumb']=array("All Invoice"=>$configs['vpath'] ."invoice/view-invoice","Create All Invoice"=>"");
		
		$data['db_list']=getQueryByJoin(array("student as s","login as l"),"s.*",array("l.status"=>"Y","s.end_date >"=>date("Y-m-d")),array("s.user_id"=>"l.user_id"));
		
		$n=0; 
		foreach($data['db_list'] as $d)
		{
		  
		   $dates=getDueDate($d['start_date'],$d['end_date'],$d['payment_duration']);
		   
		   
		   for($i=0;$i<count($dates);$i++)
		   {
		   	    $exist=getTotalRow("invoice",array("user_id"=>$d['user_id'],"due_date"=>$dates[$i]));
		   	    if(!$exist)
		   	    {
		   	  	   insertTable("invoice",array("user_id"=>$d['user_id'],"due_date"=>$dates[$i],"amount"=>$d['amount'],"net_amount"=>$d['amount'],"due_amount"=>$d['amount'],"paid_amount"=>0,"discount"=>0,"status"=>"N"));
	               $n++;
		   	    }
		   }
  
		}
	    $data['msg']=(int)$n ." invoices created.";
	
	    
	break;
	
    case "print-invoice":
    
	    

		// instantiate and use the dompdf class
		$dompdf = new Dompdf();
		$options = new Options();
		$options->set('isRemoteEnabled', TRUE);
		$dompdf = new Dompdf($options);
    
		$db_value= getDataByWhere('invoice','*',array('id'=>$_GET['id']));
		
		$student=getDataByJoin(array("student as s","login as l"),"l.*,s.*",array("l.user_id"=>$db_value['user_id']),array("s.user_id"=>"l.user_id")); 
	   
	    $html ='
		<html>
		<head><meta http-equiv=Content-Type content="text/html; charset=UTF-8">
		</head>
		<body>
		
		<table width=100% border=0 cellpadding=4>
		<tr><td><img src="'.$configs['vpath'].'img/logo.png"></td><td align=right><h1>INVOICE</h1></td></tr>
		<tr><td><h2>ASVAB Tutoring</h2>www.asvab-tutoring.com<br>Debbrata Das<br>somdtutoring@gmail.com<br>
        (718)-200-6396</td><td align=right>Invoice No #:0'.$_GET['id'].'<br>Invoice Date: '.showdate($db_value['due_date']).'<br>Due Date: '.showdate($db_value['due_date']) .'<br><b>Due Amount : $'.number_format($db_value['net_amount'],2).'</b></td></tr>
		<tr><td >Bill To : <br>
		Name : <b>' .ucwords($student['first_name'] . " ". $student['last_name']) .'</b><br> 
		Email : '.$student['email'] .'<br>
		Mobile : '.$student['mobile'] .'
		</td><td align=right>	<img src="'.$configs['vpath'].'img/qrcode.jpg"><br><h4>SCAN.PAY.GO</h4></td></tr>
			
		</table>
		<hr>
		
		<br>
		<table width=100% border=0 cellpadding=6 cellspacing=1 style="background:#c0c0c0">
		<tr style="background:silver"><td >Description</td><td >Quantity</td><td align=right >Price</td><td align=right >Amount</td></tr>
		<tr style="background:#fff"><td>Asvab Tutoring Fess</td><td >1</td><td align=right>$'.number_format($db_value['amount'],2).'</td><td align=right>$'.number_format($db_value['amount'],2).'</td></tr>
		<tr style="background:#fff"><td colspan=3><b>Sub Total</b></td><td align=right>$'.number_format($db_value['amount'],2).'</td></tr>
		<tr style="background:#fff"><td colspan=3>Discount</td><td align=right>-$'.number_format((int)$db_value['discount'],2).'</td></tr>
		<tr style="background:#fff"><td colspan=3><b>Total</b></td><td align=right>$'.number_format($db_value['net_amount'],2).'</td></tr>
		<tr style="background:#fff"><td colspan=3>Amount Paid</td><td align=right>-$'.number_format((int)$db_value['paid_amount'],2).'</td></tr>
		<tr style="background:#fff"><td colspan=3>Amount Due</td><td align=right>$'.number_format((int)$db_value['due_amount'],2).'</td></tr>
				
		</table>
		
		<p style="height:100"></p>
		<hr>
		<center>ASVAB TUTORING LLC |  www.asvab-tutoring.com</center>
		</body>
		</html>';
		
		$dompdf->loadHtml($html);

		// (Optional) Setup the paper size and orientation
		$dompdf->set_paper(DEFAULT_PDF_PAPER_SIZE, 'portrait');


		// Render the HTML as PDF
		$dompdf->render();

		 
		// Output the generated PDF to Browser
		//$dompdf->stream();

		$output = $dompdf->output();
		file_put_contents($configs['apath']."uploads/invoice/0".$_GET['id'].".pdf", $output);
		$filename=$configs['vpath']."uploads/invoice/0".$_GET['id'].".pdf";
		// Header content type 
		header('Content-type: application/pdf'); 
		  
		header('Content-Disposition: inline; filename="' . $filename . '"'); 
		  
		header('Content-Transfer-Encoding: binary'); 
		  
		header('Accept-Ranges: bytes'); 
		  
		// Read the file 
		@readfile($filename); 
		
	break;


}      
 
$data['action']=$_GET['action'];
echo template($data); 
?>
 

