---
title: Linear Radial Axis
---

The linear radial scale is used to chart numerical data. As the name suggests, linear interpolation is used to determine where a value lies in relation the center of the axis.

The following additional configuration options are provided by the radial linear scale.

## Configuration Options

The axis has configuration properties for ticks, angle lines (line that appear in a radar chart outward from the center), pointLabels (labels around the edge in a radar chart). The following sections define each of the properties in those sections.

| Name | Type | Default | Description
| ---- | ---- | ------- | -----------
| `angleLines` | `object` | | Angle line configuration. [more...](#angle-line-options)
| `beginAtZero` | `boolean` | `false` | if true, scale will include 0 if it is not already included.
| `gridLines` | `object` | | Grid line configuration. [more...](../styling.md#grid-line-configuration)
| `min` | `number` | | User defined minimum number for the scale, overrides minimum value from data. [more...](#axis-range-settings)
| `max` | `number` | | User defined maximum number for the scale, overrides maximum value from data. [more...](#axis-range-settings)
| `pointLabels` | `object` | | Point label configuration. [more...](#point-label-options)
| `suggestedMax` | `number` | | Adjustment used when calculating the maximum data value. [more...](#axis-range-settings)
| `suggestedMin` | `number` | | Adjustment used when calculating the minimum data value. [more...](#axis-range-settings)
| `ticks` | `object` | | Tick configuration. [more...](#tick-options)

## Tick Options

The following options are provided by the linear radial scale. They are all located in the `ticks` sub options. The [common tick configuration](../styling.md#tick-configuration) options are supported by this axis.

| Name | Type | Scriptable | Default | Description
| ---- | ---- | ------- | ------- | -----------
| `backdropColor` | `Color` | Yes | `'rgba(255, 255, 255, 0.75)'` | Color of label backdrops.
| `backdropPaddingX` | `number` | | `2` | Horizontal padding of label backdrop.
| `backdropPaddingY` | `number` | | `2` | Vertical padding of label backdrop.
| `format` | `object` | | | The [`Intl.NumberFormat`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/NumberFormat) options used by the default label formatter
| `maxTicksLimit` | `number` | | `11` | Maximum number of ticks and gridlines to show.
| `precision` | `number` | | | if defined and `stepSize` is not specified, the step size will be rounded to this many decimal places.
| `stepSize` | `number` | | | User defined fixed step size for the scale. [more...](#step-size)
| `showLabelBackdrop` | `boolean` | Yes | `true` | If true, draw a background behind the tick labels.

The scriptable context has the following form:

```javascript
{
    chart,
    scale,
    index,
    tick
}
```

## Axis Range Settings

Given the number of axis range settings, it is important to understand how they all interact with each other.

The `suggestedMax` and `suggestedMin` settings only change the data values that are used to scale the axis. These are useful for extending the range of the axis while maintaining the auto fit behaviour.

```javascript
let minDataValue = Math.min(mostNegativeValue, options.ticks.suggestedMin);
let maxDataValue = Math.max(mostPositiveValue, options.ticks.suggestedMax);
```

In this example, the largest positive value is 50, but the data maximum is expanded out to 100. However, because the lowest data value is below the `suggestedMin` setting, it is ignored.

```javascript
let chart = new Chart(ctx, {
    type: 'radar',
    data: {
        datasets: [{
            label: 'First dataset',
            data: [0, 20, 40, 50]
        }],
        labels: ['January', 'February', 'March', 'April']
    },
    options: {
        scale: {
            suggestedMin: 50,
            suggestedMax: 100
        }
    }
});
```

In contrast to the `suggested*` settings, the `min` and `max` settings set explicit ends to the axes. When these are set, some data points may not be visible.

## Step Size

If set, the scale ticks will be enumerated by multiple of `stepSize`, having one tick per increment. If not set, the ticks are labeled automatically using the nice numbers algorithm.

This example sets up a chart with a y axis that creates ticks at `0, 0.5, 1, 1.5, 2, 2.5, 3, 3.5, 4, 4.5, 5`.

```javascript
let options = {
    scale: {
        max: 5,
        min: 0,
        ticks: {
            stepSize: 0.5
        }
    }
};
```

## Angle Line Options

The following options are used to configure angled lines that radiate from the center of the chart to the point labels. They can be found in the `angleLines` sub options.

| Name | Type | Scriptable | Default | Description
| ---- | ---- | ------- | ------- | -----------
| `display` | `boolean` | | `true` | if true, angle lines are shown.
| `color` | `Color` | Yes | `'rgba(0, 0, 0, 0.1)'` | Color of angled lines.
| `lineWidth` | `number` | Yes | `1` | Width of angled lines.
| `borderDash` | `number[]` | Yes* | `[]` | Length and spacing of dashes on angled lines. See [MDN](https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/setLineDash).
| `borderDashOffset` | `number` | Yes | `0.0` | Offset for line dashes. See [MDN](https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset).

The `borderDash` setting only accepts a static value or a function. Passing an array of arrays is not supported.

The scriptable context has the following form:

```javascript
{
    chart,
    scale,
    index,
    label
}
```

## Point Label Options

The following options are used to configure the point labels that are shown on the perimeter of the scale. They can be found in the `pointLabels` sub options.

| Name | Type | Scriptable | Default | Description
| ---- | ---- | ------- | ------- | -----------
| `display` | `boolean` | | `true` | if true, point labels are shown.
| `callback` | `function` | | | Callback function to transform data labels to point labels. The default implementation simply returns the current string.
| `font` | `Font` | Yes | `defaults.font` | See [Fonts](../general/fonts.md)

The scriptable context is the same as for the [Angle Line Options](#angle-line-options).

## Internal data format

Internally linear radial scale uses numeric data
